﻿Imports System.Windows.Forms

Public Class ZoomSettingsDialog
    Dim ZoomSettings As New Settings1
    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.OK
        Me.Close()
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.Close()
    End Sub

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
        For I As Integer = 10 To 400
            Me.ListBoxPercentage.Items.Add(I & "%")
        Next
        If ZoomSettings.ZoomLevel >= 10 Then
            Me.ListBoxPercentage.SelectedIndex = Me.ListBoxPercentage.FindString(ZoomSettings.ZoomLevel & "%")
        End If
        For I As Integer = 8 To 74
            Me.ComboBoxCharSize.Items.Add(I)
        Next
        Me.ComboBoxCharSize.SelectedIndex = Me.ComboBoxCharSize.FindString("10")
        If ZoomSettings.ViewCharSize >= 8 Then
            Me.ComboBoxCharSize.SelectedIndex = Me.ComboBoxCharSize.FindString(ZoomSettings.ViewCharSize)
        End If
    End Sub

    Private Sub lblPerc_GotFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles lblPerc.GotFocus
        Me.ListBoxPercentage.Focus()
    End Sub

    Private Sub btn200Perc_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn200Perc.Click
        Dim index As Integer = ListBoxPercentage.FindString("200%")
        Me.ListBoxPercentage.SetSelected(index, True)
    End Sub

    Private Sub btn100Perc_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn100Perc.Click
        Dim index As Integer = ListBoxPercentage.FindString("100%")
        Me.ListBoxPercentage.SetSelected(index, True)
    End Sub

    Private Sub btn75Perc_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn75Perc.Click
        Dim index As Integer = ListBoxPercentage.FindString("75%")
        Me.ListBoxPercentage.SetSelected(index, True)
    End Sub

    Private Sub ListBoxPercentage_SelectedValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListBoxPercentage.SelectedValueChanged
        Select Case Me.ListBoxPercentage.SelectedItem.ToString
            Case "75%"
                btn75Perc.Checked = True
            Case "100%"
                btn100Perc.Checked = True
            Case "200%"
                btn200Perc.Checked = True
            Case Else
                btn75Perc.Checked = False
                btn100Perc.Checked = False
                btn200Perc.Checked = False
        End Select
    End Sub

    Private Sub grpStandardZoomLevel_Enter(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles grpStandardZoomLevel.Enter

    End Sub
End Class
